<?= $this-> include('templates/header');?>
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="<?= base_url('ns-admin') ?>"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?= isset($pageTitle) ? esc($pageTitle) : "" ?></li>
            </ol>
        </nav>
        <div class="row g-4">
            <div class="col-12">
                <div class="card h-100">
                    <div class="card-body p-4">
                        <form action="<?= base_url('/ns-admin/create_episode_handler') ?>" name="addeditepisode" method="POST" enctype="multipart/form-data">
                            <?= csrf_field() ?>
                            <input  type="hidden" name="episode_id" value="<?= isset($episode_id) ? esc($episode_id) : '' ?>" />
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Podcast</label>
                                <div class="col-sm-10">
                                    <select name="podcast_id" id="podcast_id" class="nsofts-select" required>
                                        <option value="">--Select Podcast--</option>
                                        <?php foreach($podcas_result as $podcas_row){ ?>      
                                            <?php if(isset($episode_id)){ ?>
                                                <option value="<?= isset($podcas_row['pid']) ? esc($podcas_row['pid']) : '' ?>" <?php if($podcas_row['pid']==$row['podcast_id']){?>selected<?php }?>><?= isset($podcas_row['podcast_name']) ? esc($podcas_row['podcast_name']) : '' ?></option>   							 
                                            <?php } else { ?>
                                                <option value="<?= isset($podcas_row['pid']) ? esc($podcas_row['pid']) : '' ?>"><?= isset($podcas_row['podcast_name']) ? esc($podcas_row['podcast_name']) : '' ?></option>
                                            <?php } ?>
                                        <?php } ?> 
                                    </select>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">Title</label>
                                <div class="col-sm-10">
                                     <input type="text" name="episode_title" class="form-control" value="<?= isset($episode_id) ? esc($row['episode_title']) : '' ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <label class="col-sm-2 col-form-label">URL</label>
                                <div class="col-sm-10">
                                     <input type="text" name="episode_url" class="form-control" value="<?= isset($episode_id) ? esc($row['episode_url']) : '' ?>" required>
                                </div>
                            </div>
                            
                            <div class="mb-3 row">
                                <div class="mb-3 row">
                                    <label class="col-sm-2 col-form-label">&nbsp;</label>
                                    <div class="col-sm-10">
                                        <button type="submit" name="submit" class="btn btn-primary" style="min-width: 120px;"><?=$pageSave?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?= $this-> include('templates/footer');?>